program enditall;

// Copyright  2001 by Ziff-Davis, Inc.
// Written by Neil J. Rubenking

{$R 'moreres.res' 'moreres.rc'}

uses
  Forms,
  SysUtils,
  Windows,
  enditu in 'enditu.pas' {EndItForm},
  endfuncu in 'endfuncu.pas',
  reObjs in 'reObjs.pas',
  AboutBox in 'Aboutbox.pas' {AboutForm},
  syntaxu in 'syntaxu.pas' {SyntaxForm},
  dontu in 'dontu.pas' {DontForm},
  cloThdU in 'cloThdU.pas';

{$R *.RES}

TYPE
  TShared = Record
    AppHandle : THandle;
    WinHandle : THandle;
  end;
VAR
  ShareData   : ^TShared;
  hMap : THandle;
CONST
  MainMapName : PChar = 'PC Magazine EndItAll Shared '+
    '{FA1EF826-9612-4E7C-8AFE-DEE1C17CA60E}';

procedure ParseCmdLine;
VAR S : String;
begin
  S := CmdLine;
  System.Delete(S, 1, Length(ParamStr(0))+2);
  InitAction := 0; // no action
  InitFName := Trim(S);
  IF ParamCount = 0 THEN Exit;
  InitAction := -1; // syntax error
  IF ParamCount > 1 THEN Exit;
  S := Uppercase(ParamStr(1));
  IF Length(S) < 2 THEN Exit;
  IF NOT (S[1] IN ['-','/']) THEN Exit;
  IF (Length(S) > 2) AND (S[3] <> ':') THEN Exit;
  CASE S[2] OF
    'C' : InitAction := 1;
    'K' : InitAction := 2;
    ELSE Exit;
  END;
  Delete(S, 1, 3);
  S := Trim(StringReplace(S, '"', '', [rfReplaceAll]));
  IF (Pos('\', S) > 0) OR (Pos(':', S) > 0) THEN
    InitAction := -1
  ELSE IF S <> '' THEN
    begin
      InitFName := S;
      Inc(InitAction, 2);
    end;
end;

function ComCtlVersionIs4_70 : boolean;
type
  PDllVersionInfo = ^TDllVersionInfo;
  TDllVersionInfo = record
    cbSize          : DWORD;
    dwMajorVersion  : DWORD;
    dwMinorVersion  : DWORD;
    dwBuildNumber   : DWORD;
    dwPlatformID    : DWORD;
  end;
  DllGetVersionType = function (pdvi : PDllVersionInfo) :
    HRESULT; stdcall;
VAR
  LibH : hModule;
  DllGetVersion  : DllGetVersionType;
  DVI  : TDllVersionInfo;
begin
  Result := False;
  LibH := LoadLibrary('ComCtl32.dll');
  IF LibH <= 32 THEN Exit;
  try
    @DllGetVersion := GetProcAddress(LibH, 'DllGetVersion');
    IF @DllGetVersion = nil THEN Exit;
    FillChar(DVI, SizeOf(DVI), 0);
    DVI.cbSize := SizeOf(DVI);
    IF DllGetVersion(@DVI) = NOERROR THEN
      begin
        IF DVI.dwMajorVersion > 4 THEN Result := True
        ELSE IF (DVI.dwMajorVersion = 4) AND
          (DVI.dwMinorVersion >= 70) THEN Result := True;
      end;
  finally
    FreeLibrary(LibH);
  end;
end;


begin
  IF NOT ComCtlVersionIs4_70 THEN
    begin
      MessageBox(0, 'EndItAll requires version 4.7 or later of the '+
        'system library ComCtl32.dll. This system has an older vers'+
        'ion. You can update this library by installing Internet Ex'+
        'plorer 3 or later (even if you uninstall it afterward). Or'+
        ' you can download just the updated library from the URL be'+
        'low.'#13#10#13#10'http://www.microsoft.com/msdownload/iepl'+
        'atform/ie/comctrlx86.asp.', 'EndItAll',
        MB_OK OR MB_ICONSTOP);
      Halt;
    end;
  EndItMsg := RegisterWindowMessage(MainMapName);
  hMap := OpenFileMapping(FILE_MAP_ALL_ACCESS, False, MainMapName);
  ParseCmdLine;
  IF hMap = 0 THEN // first instance
    begin
      hMap := CreateFileMapping($FFFFFFFF, NIL, PAGE_READWRITE, 0,
        SizeOf(TShared), MainMapName);
      ShareData := MapViewOfFile(hMap, FILE_MAP_ALL_ACCESS, 0, 0, 0);
      Application.Initialize;
      Application.Title := 'EndItAll';
      Application.CreateForm(TEndItForm, EndItForm);
  EndItForm.HandleNeeded;
      ShareData^.AppHandle := Application.Handle;
      ShareData^.WinHandle := EndItForm.Handle;
      Application.Run;
    end
  ELSE
    begin
      ShareData := MapViewOfFile(hMap, FILE_MAP_ALL_ACCESS, 0, 0, 0);
      // IF this is a valid request for action via command-line,
      // then run another instance...
      IF InitAction > 0 THEN
        begin
          Application.Initialize;
          Application.Title := 'EndItAll';
          Application.CreateForm(TEndItForm, EndItForm);
          Application.Run;
          // ... and refresh the first intance
          PostMessage(ShareData^.WinHandle, EndItMsg, 1,
            GetCurrentProcessID);
        end
      ELSE
        begin
          // Otherwise, activate the first instance...
          IF IsIconic(ShareData^.AppHandle) THEN
            ShowWindow(ShareData^.AppHandle, SW_RESTORE);
          SetForegroundWindow(ShareData^.WinHandle);
          // ... and give a syntax lesson, if necessary
          IF InitAction < 0 THEN
            PostMessage(ShareData^.WinHandle, EndItMsg,
              0, 0);
        end;
    end;
  UnMapViewOfFile(ShareData);
  CloseHandle(hMap);
end.


